/*
 * Segundo Exemplo do Tutorial de J2ME
 *
 * @author Tarcisio Camara
 */
import java.io.IOException;
import javax.microedition.midlet.MIDlet;
import javax.microedition.lcdui.*;

/**
 * Essa classe representa a tela da aplicao
 * Ela deve estender da classe Canvas, desenhar
 * uma string na tela e tratar os comandos para
 * mudar a cor da string.
 */
public class MeuCanvas extends Canvas {

    /** tabela com as cores */
    private final int cores[]
            = new int[]{0xffffff,0xffff00,0xff00ff,0x00ffff,
                        0x0000ff,0x000000,0xff0000};

    /** Fonte usada para escrever na tela */
    private static final Font fonte = Font.getFont(Font.FACE_SYSTEM,
                                                   Font.STYLE_PLAIN,
                                                   Font.SIZE_MEDIUM);

    /** Texto a ser escrito na tela */
    private String texto;

    /** indice da cor corrente do texto */
    private int indice;
    
    /** Imagem do IN2 games */
    private Image imagem;

    /**
     * Construtor
     * @param texto Texto a ser renderizado
     */
    public MeuCanvas(String texto){
        //Seta o texto a ser mostrado
        this.texto = texto;

        //carrega a imagem
        try{
            imagem = Image.createImage("/imagem.png");
        }catch(IOException io){
           System.out.println("Erro ao carregar imagem");
        }
    }

    /**
     * Mtodo que deve ser implementado pela classe canvas.
     * Aqui fica toda a lgica de pintura do canvas. Esse mtodo
     *  chamado sempre que um repaint()  invocado.
     * @param g O Contexto grfico do canvas
     */
    public void paint (Graphics g) {
      //Seta a cor que ser pintada no fundo
      g.setColor(0xFF00FF);

      //Usa o mtodo fillRect para pintar a tela inteira
      g.fillRect(0,0,getWidth(),getHeight());

      //Seta a fonte que ser usada
      g.setFont(fonte);

      //Seta a cor que o teto ser pintado (baseado no indice do array)
      g.setColor(cores[indice]);

      //Renderiza o texto centralizado na tela
      g.drawString(texto,(getWidth() - fonte.stringWidth(texto))/2,
                         (getHeight() - fonte.getHeight())/2,
                         g.TOP | g.LEFT);

     //Pinta a imagem no canto esquerdo superior da tela
     g.drawImage(imagem,0,0,g.TOP|g.LEFT);

    }

    /**
     * Mtodo invocado sempre que uma tecla  pressionada
     * @param keyCode Cdigo da tecla pressionada
     */
    public void keyPressed(int keyCode){
        switch(getGameAction(keyCode)){
          //Caso a tecla pressionada seja a tecla pra cima
          case Canvas.UP:
              indice = indice < cores.length - 1 ? (indice + 1) : indice;
              break;
          //Caso a tecla pressionada seja a tecla pra baixo
          case Canvas.DOWN:
              indice = indice > 0 ? (indice - 1) : indice;
              break;
        }
        //Chamada para repintar a tela
        repaint();
        serviceRepaints();
    }

}

